package io.k8s.apimachinery.pkg.apis.meta.v1


/** Event represents a single event to a watched resource. */
final case class WatchEvent(
  `object` : io.k8s.apimachinery.pkg.runtime.RawExtension,
  `type` : String
) {

  /** Returns a new data with `object` set to new value */
  def withObject(value: io.k8s.apimachinery.pkg.runtime.RawExtension) : WatchEvent = copy(`object` = value)
  /** transforms `object` to result of function */
  def mapObject(f: io.k8s.apimachinery.pkg.runtime.RawExtension => io.k8s.apimachinery.pkg.runtime.RawExtension) : WatchEvent = copy(`object` = f(`object`))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : WatchEvent = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : WatchEvent = copy(`type` = f(`type`))
}

