package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** ReplicaSetSpec is the specification of a ReplicaSet. */
final case class ReplicaSetSpec(
  selector : io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector,
  minReadySeconds : Option[Int] = None,
  replicas : Option[Int] = None,
  template : Option[io.k8s.api.core.v1.PodTemplateSpec] = None
) {

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ReplicaSetSpec = copy(selector = value)
  /** transforms selector to result of function */
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : ReplicaSetSpec = copy(selector = f(selector))

  /** Returns a new data with minReadySeconds set to new value */
  def withMinReadySeconds(value: Int) : ReplicaSetSpec = copy(minReadySeconds = Some(value))
  /** if minReadySeconds has a value, transforms to the result of function*/
  def mapMinReadySeconds(f: Int => Int) : ReplicaSetSpec = copy(minReadySeconds = minReadySeconds.map(f))

  /** Returns a new data with replicas set to new value */
  def withReplicas(value: Int) : ReplicaSetSpec = copy(replicas = Some(value))
  /** if replicas has a value, transforms to the result of function*/
  def mapReplicas(f: Int => Int) : ReplicaSetSpec = copy(replicas = replicas.map(f))

  /** Returns a new data with template set to new value */
  def withTemplate(value: io.k8s.api.core.v1.PodTemplateSpec) : ReplicaSetSpec = copy(template = Some(value))
  /** if template has a value, transforms to the result of function*/
  def mapTemplate(f: io.k8s.api.core.v1.PodTemplateSpec => io.k8s.api.core.v1.PodTemplateSpec) : ReplicaSetSpec = copy(template = template.map(f))
}

object ReplicaSetSpec {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.ReplicaSetSpec] = new Encoder[io.k8s.api.apps.v1.ReplicaSetSpec] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.ReplicaSetSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("selector", o.selector)
            .write("minReadySeconds", o.minReadySeconds)
            .write("replicas", o.replicas)
            .write("template", o.template)
            .build
        }
    }

    implicit val decoder: Decoder[ReplicaSetSpec] = new Decoder[ReplicaSetSpec] {
      def apply[T : Reader](t: T): Either[String, ReplicaSetSpec] = for {
          obj <- ObjectReader(t)
          selector <- obj.read[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
          minReadySeconds <- obj.readOpt[Int]("minReadySeconds")
          replicas <- obj.readOpt[Int]("replicas")
          template <- obj.readOpt[io.k8s.api.core.v1.PodTemplateSpec]("template")
      } yield ReplicaSetSpec (
          selector = selector,
          minReadySeconds = minReadySeconds,
          replicas = replicas,
          template = template
        )
    }
}

