package io.k8s.api.apps.v1

import dev.hnaderi.k8s.utils._

/** RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType. */
final case class RollingUpdateStatefulSetStrategy(
  maxUnavailable : Option[io.k8s.apimachinery.pkg.util.intstr.IntOrString] = None,
  partition : Option[Int] = None
) {

  /** Returns a new data with maxUnavailable set to new value */
  def withMaxUnavailable(value: io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateStatefulSetStrategy = copy(maxUnavailable = Some(value))
  /** if maxUnavailable has a value, transforms to the result of function*/
  def mapMaxUnavailable(f: io.k8s.apimachinery.pkg.util.intstr.IntOrString => io.k8s.apimachinery.pkg.util.intstr.IntOrString) : RollingUpdateStatefulSetStrategy = copy(maxUnavailable = maxUnavailable.map(f))

  /** Returns a new data with partition set to new value */
  def withPartition(value: Int) : RollingUpdateStatefulSetStrategy = copy(partition = Some(value))
  /** if partition has a value, transforms to the result of function*/
  def mapPartition(f: Int => Int) : RollingUpdateStatefulSetStrategy = copy(partition = partition.map(f))
}

object RollingUpdateStatefulSetStrategy {

    implicit val encoder : Encoder[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] = new Encoder[io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy] {
        def apply[T : Builder](o: io.k8s.api.apps.v1.RollingUpdateStatefulSetStrategy) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("maxUnavailable", o.maxUnavailable)
            .write("partition", o.partition)
            .build
        }
    }

    implicit val decoder: Decoder[RollingUpdateStatefulSetStrategy] = new Decoder[RollingUpdateStatefulSetStrategy] {
      def apply[T : Reader](t: T): Either[String, RollingUpdateStatefulSetStrategy] = for {
          obj <- ObjectReader(t)
          maxUnavailable <- obj.readOpt[io.k8s.apimachinery.pkg.util.intstr.IntOrString]("maxUnavailable")
          partition <- obj.readOpt[Int]("partition")
      } yield RollingUpdateStatefulSetStrategy (
          maxUnavailable = maxUnavailable,
          partition = partition
        )
    }
}

