package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.utils._

/** BoundObjectReference is a reference to an object that a token is bound to. */
final case class BoundObjectReference(
  name : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : BoundObjectReference = copy(name = Some(value))
  /** if name has a value, transforms to the result of function*/
  def mapName(f: String => String) : BoundObjectReference = copy(name = name.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : BoundObjectReference = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : BoundObjectReference = copy(uid = uid.map(f))
}

object BoundObjectReference {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.BoundObjectReference] = new Encoder[io.k8s.api.authentication.v1.BoundObjectReference] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.BoundObjectReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("uid", o.uid)
            .build
        }
    }

    implicit val decoder: Decoder[BoundObjectReference] = new Decoder[BoundObjectReference] {
      def apply[T : Reader](t: T): Either[String, BoundObjectReference] = for {
          obj <- ObjectReader(t)
          name <- obj.readOpt[String]("name")
          uid <- obj.readOpt[String]("uid")
      } yield BoundObjectReference (
          name = name,
          uid = uid
        )
    }
}

