package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** MetricIdentifier defines the name and optionally selector for a metric */
final case class MetricIdentifier(
  name : String,
  selector : Option[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : MetricIdentifier = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : MetricIdentifier = copy(name = f(name))

  /** Returns a new data with selector set to new value */
  def withSelector(value: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MetricIdentifier = copy(selector = Some(value))
  /** if selector has a value, transforms to the result of function*/
  def mapSelector(f: io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector => io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector) : MetricIdentifier = copy(selector = selector.map(f))
}

object MetricIdentifier {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2.MetricIdentifier] = new Encoder[io.k8s.api.autoscaling.v2.MetricIdentifier] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2.MetricIdentifier) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("selector", o.selector)
            .build
        }
    }

    implicit val decoder: Decoder[MetricIdentifier] = new Decoder[MetricIdentifier] {
      def apply[T : Reader](t: T): Either[String, MetricIdentifier] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          selector <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.LabelSelector]("selector")
      } yield MetricIdentifier (
          name = name,
          selector = selector
        )
    }
}

