package io.k8s.api.batch.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CronJobList is a collection of cron jobs. */
final case class CronJobList(
  items : Seq[io.k8s.api.batch.v1.CronJob],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "CronJobList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.batch.v1.CronJob]) : CronJobList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.batch.v1.CronJob*) : CronJobList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.batch.v1.CronJob] => Seq[io.k8s.api.batch.v1.CronJob]) : CronJobList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CronJobList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CronJobList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CronJobList.encoder.apply(this)
}

object CronJobList {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.CronJobList] = new Encoder[io.k8s.api.batch.v1.CronJobList] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.CronJobList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[CronJobList] = new Decoder[CronJobList] {
      def apply[T : Reader](t: T): Either[String, CronJobList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.batch.v1.CronJob]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CronJobList (
          items = items,
          metadata = metadata
        )
    }
}

