package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling. */
final case class CephFSVolumeSource(
  monitors : Seq[String],
  path : Option[String] = None,
  readOnly : Option[Boolean] = None,
  secretRef : Option[io.k8s.api.core.v1.LocalObjectReference] = None,
  secretFile : Option[String] = None,
  user : Option[String] = None
) {

  /** Returns a new data with monitors set to new value */
  def withMonitors(value: Seq[String]) : CephFSVolumeSource = copy(monitors = value)
  /** Appends new values to monitors */
  def addMonitors(newValues: String*) : CephFSVolumeSource = copy(monitors = monitors ++ newValues)
  /** transforms monitors to result of function */
  def mapMonitors(f: Seq[String] => Seq[String]) : CephFSVolumeSource = copy(monitors = f(monitors))

  /** Returns a new data with path set to new value */
  def withPath(value: String) : CephFSVolumeSource = copy(path = Some(value))
  /** if path has a value, transforms to the result of function*/
  def mapPath(f: String => String) : CephFSVolumeSource = copy(path = path.map(f))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : CephFSVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : CephFSVolumeSource = copy(readOnly = readOnly.map(f))

  /** Returns a new data with secretRef set to new value */
  def withSecretRef(value: io.k8s.api.core.v1.LocalObjectReference) : CephFSVolumeSource = copy(secretRef = Some(value))
  /** if secretRef has a value, transforms to the result of function*/
  def mapSecretRef(f: io.k8s.api.core.v1.LocalObjectReference => io.k8s.api.core.v1.LocalObjectReference) : CephFSVolumeSource = copy(secretRef = secretRef.map(f))

  /** Returns a new data with secretFile set to new value */
  def withSecretFile(value: String) : CephFSVolumeSource = copy(secretFile = Some(value))
  /** if secretFile has a value, transforms to the result of function*/
  def mapSecretFile(f: String => String) : CephFSVolumeSource = copy(secretFile = secretFile.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: String) : CephFSVolumeSource = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: String => String) : CephFSVolumeSource = copy(user = user.map(f))
}

object CephFSVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.CephFSVolumeSource] = new Encoder[io.k8s.api.core.v1.CephFSVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.CephFSVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("monitors", o.monitors)
            .write("path", o.path)
            .write("readOnly", o.readOnly)
            .write("secretRef", o.secretRef)
            .write("secretFile", o.secretFile)
            .write("user", o.user)
            .build
        }
    }

    implicit val decoder: Decoder[CephFSVolumeSource] = new Decoder[CephFSVolumeSource] {
      def apply[T : Reader](t: T): Either[String, CephFSVolumeSource] = for {
          obj <- ObjectReader(t)
          monitors <- obj.read[Seq[String]]("monitors")
          path <- obj.readOpt[String]("path")
          readOnly <- obj.readOpt[Boolean]("readOnly")
          secretRef <- obj.readOpt[io.k8s.api.core.v1.LocalObjectReference]("secretRef")
          secretFile <- obj.readOpt[String]("secretFile")
          user <- obj.readOpt[String]("user")
      } yield CephFSVolumeSource (
          monitors = monitors,
          path = path,
          readOnly = readOnly,
          secretRef = secretRef,
          secretFile = secretFile,
          user = user
        )
    }
}

