package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ConfigMapNodeConfigSource contains the information to reference a ConfigMap as a config source for the Node. This API is deprecated since 1.22: https://git.k8s.io/enhancements/keps/sig-node/281-dynamic-kubelet-configuration */
final case class ConfigMapNodeConfigSource(
  name : String,
  kubeletConfigKey : String,
  namespace : String,
  resourceVersion : Option[String] = None,
  uid : Option[String] = None
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ConfigMapNodeConfigSource = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ConfigMapNodeConfigSource = copy(name = f(name))

  /** Returns a new data with kubeletConfigKey set to new value */
  def withKubeletConfigKey(value: String) : ConfigMapNodeConfigSource = copy(kubeletConfigKey = value)
  /** transforms kubeletConfigKey to result of function */
  def mapKubeletConfigKey(f: String => String) : ConfigMapNodeConfigSource = copy(kubeletConfigKey = f(kubeletConfigKey))

  /** Returns a new data with namespace set to new value */
  def withNamespace(value: String) : ConfigMapNodeConfigSource = copy(namespace = value)
  /** transforms namespace to result of function */
  def mapNamespace(f: String => String) : ConfigMapNodeConfigSource = copy(namespace = f(namespace))

  /** Returns a new data with resourceVersion set to new value */
  def withResourceVersion(value: String) : ConfigMapNodeConfigSource = copy(resourceVersion = Some(value))
  /** if resourceVersion has a value, transforms to the result of function*/
  def mapResourceVersion(f: String => String) : ConfigMapNodeConfigSource = copy(resourceVersion = resourceVersion.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : ConfigMapNodeConfigSource = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : ConfigMapNodeConfigSource = copy(uid = uid.map(f))
}

object ConfigMapNodeConfigSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ConfigMapNodeConfigSource] = new Encoder[io.k8s.api.core.v1.ConfigMapNodeConfigSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ConfigMapNodeConfigSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("kubeletConfigKey", o.kubeletConfigKey)
            .write("namespace", o.namespace)
            .write("resourceVersion", o.resourceVersion)
            .write("uid", o.uid)
            .build
        }
    }

    implicit val decoder: Decoder[ConfigMapNodeConfigSource] = new Decoder[ConfigMapNodeConfigSource] {
      def apply[T : Reader](t: T): Either[String, ConfigMapNodeConfigSource] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          kubeletConfigKey <- obj.read[String]("kubeletConfigKey")
          namespace <- obj.read[String]("namespace")
          resourceVersion <- obj.readOpt[String]("resourceVersion")
          uid <- obj.readOpt[String]("uid")
      } yield ConfigMapNodeConfigSource (
          name = name,
          kubeletConfigKey = kubeletConfigKey,
          namespace = namespace,
          resourceVersion = resourceVersion,
          uid = uid
        )
    }
}

