package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaimVolumeSource references the user's PVC in the same namespace. This volume finds the bound PV and mounts that volume for the pod. A PersistentVolumeClaimVolumeSource is, essentially, a wrapper around another type of volume that is owned by someone else (the system). */
final case class PersistentVolumeClaimVolumeSource(
  claimName : String,
  readOnly : Option[Boolean] = None
) {

  /** Returns a new data with claimName set to new value */
  def withClaimName(value: String) : PersistentVolumeClaimVolumeSource = copy(claimName = value)
  /** transforms claimName to result of function */
  def mapClaimName(f: String => String) : PersistentVolumeClaimVolumeSource = copy(claimName = f(claimName))

  /** Returns a new data with readOnly set to new value */
  def withReadOnly(value: Boolean) : PersistentVolumeClaimVolumeSource = copy(readOnly = Some(value))
  /** if readOnly has a value, transforms to the result of function*/
  def mapReadOnly(f: Boolean => Boolean) : PersistentVolumeClaimVolumeSource = copy(readOnly = readOnly.map(f))
}

object PersistentVolumeClaimVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PersistentVolumeClaimVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("claimName", o.claimName)
            .write("readOnly", o.readOnly)
            .build
        }
    }

    implicit val decoder: Decoder[PersistentVolumeClaimVolumeSource] = new Decoder[PersistentVolumeClaimVolumeSource] {
      def apply[T : Reader](t: T): Either[String, PersistentVolumeClaimVolumeSource] = for {
          obj <- ObjectReader(t)
          claimName <- obj.read[String]("claimName")
          readOnly <- obj.readOpt[Boolean]("readOnly")
      } yield PersistentVolumeClaimVolumeSource (
          claimName = claimName,
          readOnly = readOnly
        )
    }
}

