package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PodReadinessGate contains the reference to a pod condition */
final case class PodReadinessGate(
  conditionType : String
) {

  /** Returns a new data with conditionType set to new value */
  def withConditionType(value: String) : PodReadinessGate = copy(conditionType = value)
  /** transforms conditionType to result of function */
  def mapConditionType(f: String => String) : PodReadinessGate = copy(conditionType = f(conditionType))
}

object PodReadinessGate {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PodReadinessGate] = new Encoder[io.k8s.api.core.v1.PodReadinessGate] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PodReadinessGate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditionType", o.conditionType)
            .build
        }
    }

    implicit val decoder: Decoder[PodReadinessGate] = new Decoder[PodReadinessGate] {
      def apply[T : Reader](t: T): Either[String, PodReadinessGate] = for {
          obj <- ObjectReader(t)
          conditionType <- obj.read[String]("conditionType")
      } yield PodReadinessGate (
          conditionType = conditionType
        )
    }
}

