package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** The node this Taint is attached to has the "effect" on any pod that does not tolerate the Taint. */
final case class Taint(
  effect : String,
  key : String,
  timeAdded : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  value : Option[String] = None
) {

  /** Returns a new data with effect set to new value */
  def withEffect(value: String) : Taint = copy(effect = value)
  /** transforms effect to result of function */
  def mapEffect(f: String => String) : Taint = copy(effect = f(effect))

  /** Returns a new data with key set to new value */
  def withKey(value: String) : Taint = copy(key = value)
  /** transforms key to result of function */
  def mapKey(f: String => String) : Taint = copy(key = f(key))

  /** Returns a new data with timeAdded set to new value */
  def withTimeAdded(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Taint = copy(timeAdded = Some(value))
  /** if timeAdded has a value, transforms to the result of function*/
  def mapTimeAdded(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : Taint = copy(timeAdded = timeAdded.map(f))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : Taint = copy(value = Some(value))
  /** if value has a value, transforms to the result of function*/
  def mapValue(f: String => String) : Taint = copy(value = value.map(f))
}

object Taint {

    implicit val encoder : Encoder[io.k8s.api.core.v1.Taint] = new Encoder[io.k8s.api.core.v1.Taint] {
        def apply[T : Builder](o: io.k8s.api.core.v1.Taint) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("effect", o.effect)
            .write("key", o.key)
            .write("timeAdded", o.timeAdded)
            .write("value", o.value)
            .build
        }
    }

    implicit val decoder: Decoder[Taint] = new Decoder[Taint] {
      def apply[T : Reader](t: T): Either[String, Taint] = for {
          obj <- ObjectReader(t)
          effect <- obj.read[String]("effect")
          key <- obj.read[String]("key")
          timeAdded <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("timeAdded")
          value <- obj.readOpt[String]("value")
      } yield Taint (
          effect = effect,
          key = key,
          timeAdded = timeAdded,
          value = value
        )
    }
}

