package io.k8s.api.discovery.v1

import dev.hnaderi.k8s.utils._

/** ForZone provides information about which zones should consume this endpoint. */
final case class ForZone(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : ForZone = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ForZone = copy(name = f(name))
}

object ForZone {

    implicit val encoder : Encoder[io.k8s.api.discovery.v1.ForZone] = new Encoder[io.k8s.api.discovery.v1.ForZone] {
        def apply[T : Builder](o: io.k8s.api.discovery.v1.ForZone) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[ForZone] = new Decoder[ForZone] {
      def apply[T : Reader](t: T): Either[String, ForZone] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield ForZone (
          name = name
        )
    }
}

