package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** LimitedPriorityLevelConfiguration specifies how to handle requests that are subject to limits. It addresses two issues:
  - How are requests for this priority level limited?
  - What should be done with requests that exceed the limit? */
final case class LimitedPriorityLevelConfiguration(
  assuredConcurrencyShares : Option[Int] = None,
  limitResponse : Option[io.k8s.api.flowcontrol.v1beta1.LimitResponse] = None
) {

  /** Returns a new data with assuredConcurrencyShares set to new value */
  def withAssuredConcurrencyShares(value: Int) : LimitedPriorityLevelConfiguration = copy(assuredConcurrencyShares = Some(value))
  /** if assuredConcurrencyShares has a value, transforms to the result of function*/
  def mapAssuredConcurrencyShares(f: Int => Int) : LimitedPriorityLevelConfiguration = copy(assuredConcurrencyShares = assuredConcurrencyShares.map(f))

  /** Returns a new data with limitResponse set to new value */
  def withLimitResponse(value: io.k8s.api.flowcontrol.v1beta1.LimitResponse) : LimitedPriorityLevelConfiguration = copy(limitResponse = Some(value))
  /** if limitResponse has a value, transforms to the result of function*/
  def mapLimitResponse(f: io.k8s.api.flowcontrol.v1beta1.LimitResponse => io.k8s.api.flowcontrol.v1beta1.LimitResponse) : LimitedPriorityLevelConfiguration = copy(limitResponse = limitResponse.map(f))
}

object LimitedPriorityLevelConfiguration {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration] = new Encoder[io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta1.LimitedPriorityLevelConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("assuredConcurrencyShares", o.assuredConcurrencyShares)
            .write("limitResponse", o.limitResponse)
            .build
        }
    }

    implicit val decoder: Decoder[LimitedPriorityLevelConfiguration] = new Decoder[LimitedPriorityLevelConfiguration] {
      def apply[T : Reader](t: T): Either[String, LimitedPriorityLevelConfiguration] = for {
          obj <- ObjectReader(t)
          assuredConcurrencyShares <- obj.readOpt[Int]("assuredConcurrencyShares")
          limitResponse <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.LimitResponse]("limitResponse")
      } yield LimitedPriorityLevelConfiguration (
          assuredConcurrencyShares = assuredConcurrencyShares,
          limitResponse = limitResponse
        )
    }
}

