package io.k8s.api.flowcontrol.v1beta1

import dev.hnaderi.k8s.utils._

/** Subject matches the originator of a request, as identified by the request authentication system. There are three ways of matching an originator; by user, group, or service account. */
final case class Subject(
  group : Option[io.k8s.api.flowcontrol.v1beta1.GroupSubject] = None,
  serviceAccount : Option[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject] = None,
  user : Option[io.k8s.api.flowcontrol.v1beta1.UserSubject] = None
) {

  /** Returns a new data with group set to new value */
  def withGroup(value: io.k8s.api.flowcontrol.v1beta1.GroupSubject) : Subject = copy(group = Some(value))
  /** if group has a value, transforms to the result of function*/
  def mapGroup(f: io.k8s.api.flowcontrol.v1beta1.GroupSubject => io.k8s.api.flowcontrol.v1beta1.GroupSubject) : Subject = copy(group = group.map(f))

  /** Returns a new data with serviceAccount set to new value */
  def withServiceAccount(value: io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject) : Subject = copy(serviceAccount = Some(value))
  /** if serviceAccount has a value, transforms to the result of function*/
  def mapServiceAccount(f: io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject => io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject) : Subject = copy(serviceAccount = serviceAccount.map(f))

  /** Returns a new data with user set to new value */
  def withUser(value: io.k8s.api.flowcontrol.v1beta1.UserSubject) : Subject = copy(user = Some(value))
  /** if user has a value, transforms to the result of function*/
  def mapUser(f: io.k8s.api.flowcontrol.v1beta1.UserSubject => io.k8s.api.flowcontrol.v1beta1.UserSubject) : Subject = copy(user = user.map(f))
}

object Subject {

    implicit val encoder : Encoder[io.k8s.api.flowcontrol.v1beta1.Subject] = new Encoder[io.k8s.api.flowcontrol.v1beta1.Subject] {
        def apply[T : Builder](o: io.k8s.api.flowcontrol.v1beta1.Subject) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("group", o.group)
            .write("serviceAccount", o.serviceAccount)
            .write("user", o.user)
            .build
        }
    }

    implicit val decoder: Decoder[Subject] = new Decoder[Subject] {
      def apply[T : Reader](t: T): Either[String, Subject] = for {
          obj <- ObjectReader(t)
          group <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.GroupSubject]("group")
          serviceAccount <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.ServiceAccountSubject]("serviceAccount")
          user <- obj.readOpt[io.k8s.api.flowcontrol.v1beta1.UserSubject]("user")
      } yield Subject (
          group = group,
          serviceAccount = serviceAccount,
          user = user
        )
    }
}

