package io.k8s.api.policy.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodDisruptionBudgetList is a collection of PodDisruptionBudgets. */
final case class PodDisruptionBudgetList(
  items : Seq[io.k8s.api.policy.v1.PodDisruptionBudget],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "PodDisruptionBudgetList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.policy.v1.PodDisruptionBudget]) : PodDisruptionBudgetList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.policy.v1.PodDisruptionBudget*) : PodDisruptionBudgetList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.policy.v1.PodDisruptionBudget] => Seq[io.k8s.api.policy.v1.PodDisruptionBudget]) : PodDisruptionBudgetList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodDisruptionBudgetList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : PodDisruptionBudgetList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodDisruptionBudgetList.encoder.apply(this)
}

object PodDisruptionBudgetList {

    implicit val encoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetList] = new Encoder[io.k8s.api.policy.v1.PodDisruptionBudgetList] {
        def apply[T : Builder](o: io.k8s.api.policy.v1.PodDisruptionBudgetList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodDisruptionBudgetList] = new Decoder[PodDisruptionBudgetList] {
      def apply[T : Reader](t: T): Either[String, PodDisruptionBudgetList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.policy.v1.PodDisruptionBudget]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield PodDisruptionBudgetList (
          items = items,
          metadata = metadata
        )
    }
}

