package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** CrossVersionObjectReference contains enough information to let you identify the referred resource. */
final case class CrossVersionObjectReference(
  name : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : CrossVersionObjectReference = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : CrossVersionObjectReference = copy(name = f(name))
}

object CrossVersionObjectReference {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2.CrossVersionObjectReference] = new Encoder[io.k8s.api.autoscaling.v2.CrossVersionObjectReference] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2.CrossVersionObjectReference) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[CrossVersionObjectReference] = new Decoder[CrossVersionObjectReference] {
      def apply[T : Reader](t: T): Either[String, CrossVersionObjectReference] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
      } yield CrossVersionObjectReference (
          name = name
        )
    }
}

