package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** ContainerResourceMetricSource indicates how to scale on a resource metric known to Kubernetes, as specified in requests and limits, describing each pod in the current scale target (e.g. CPU or memory).  The values will be averaged together before being compared to the target.  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source.  Only one "target" type should be set. */
final case class ContainerResourceMetricSource(
  container : String,
  name : String,
  target : io.k8s.api.autoscaling.v2beta2.MetricTarget
) {

  /** Returns a new data with container set to new value */
  def withContainer(value: String) : ContainerResourceMetricSource = copy(container = value)
  /** transforms container to result of function */
  def mapContainer(f: String => String) : ContainerResourceMetricSource = copy(container = f(container))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ContainerResourceMetricSource = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ContainerResourceMetricSource = copy(name = f(name))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2beta2.MetricTarget) : ContainerResourceMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2beta2.MetricTarget => io.k8s.api.autoscaling.v2beta2.MetricTarget) : ContainerResourceMetricSource = copy(target = f(target))
}

object ContainerResourceMetricSource {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource] = new Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("container", o.container)
            .write("name", o.name)
            .write("target", o.target)
            .build
        }
    }

    implicit val decoder: Decoder[ContainerResourceMetricSource] = new Decoder[ContainerResourceMetricSource] {
      def apply[T : Reader](t: T): Either[String, ContainerResourceMetricSource] = for {
          obj <- ObjectReader(t)
          container <- obj.read[String]("container")
          name <- obj.read[String]("name")
          target <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
      } yield ContainerResourceMetricSource (
          container = container,
          name = name,
          target = target
        )
    }
}

