package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** ContainerResourceMetricStatus indicates the current value of a resource metric known to Kubernetes, as specified in requests and limits, describing a single container in each pod in the current scale target (e.g. CPU or memory).  Such metrics are built in to Kubernetes, and have special scaling options on top of those available to normal per-pod metrics using the "pods" source. */
final case class ContainerResourceMetricStatus(
  container : String,
  current : io.k8s.api.autoscaling.v2beta2.MetricValueStatus,
  name : String
) {

  /** Returns a new data with container set to new value */
  def withContainer(value: String) : ContainerResourceMetricStatus = copy(container = value)
  /** transforms container to result of function */
  def mapContainer(f: String => String) : ContainerResourceMetricStatus = copy(container = f(container))

  /** Returns a new data with current set to new value */
  def withCurrent(value: io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ContainerResourceMetricStatus = copy(current = value)
  /** transforms current to result of function */
  def mapCurrent(f: io.k8s.api.autoscaling.v2beta2.MetricValueStatus => io.k8s.api.autoscaling.v2beta2.MetricValueStatus) : ContainerResourceMetricStatus = copy(current = f(current))

  /** Returns a new data with name set to new value */
  def withName(value: String) : ContainerResourceMetricStatus = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : ContainerResourceMetricStatus = copy(name = f(name))
}

object ContainerResourceMetricStatus {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus] = new Encoder[io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2beta2.ContainerResourceMetricStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("container", o.container)
            .write("current", o.current)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[ContainerResourceMetricStatus] = new Decoder[ContainerResourceMetricStatus] {
      def apply[T : Reader](t: T): Either[String, ContainerResourceMetricStatus] = for {
          obj <- ObjectReader(t)
          container <- obj.read[String]("container")
          current <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricValueStatus]("current")
          name <- obj.read[String]("name")
      } yield ContainerResourceMetricStatus (
          container = container,
          current = current,
          name = name
        )
    }
}

