package io.k8s.api.autoscaling.v2beta2

import dev.hnaderi.k8s.utils._

/** PodsMetricSource indicates how to scale on a metric describing each pod in the current scale target (for example, transactions-processed-per-second). The values will be averaged together before being compared to the target value. */
final case class PodsMetricSource(
  metric : io.k8s.api.autoscaling.v2beta2.MetricIdentifier,
  target : io.k8s.api.autoscaling.v2beta2.MetricTarget
) {

  /** Returns a new data with metric set to new value */
  def withMetric(value: io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : PodsMetricSource = copy(metric = value)
  /** transforms metric to result of function */
  def mapMetric(f: io.k8s.api.autoscaling.v2beta2.MetricIdentifier => io.k8s.api.autoscaling.v2beta2.MetricIdentifier) : PodsMetricSource = copy(metric = f(metric))

  /** Returns a new data with target set to new value */
  def withTarget(value: io.k8s.api.autoscaling.v2beta2.MetricTarget) : PodsMetricSource = copy(target = value)
  /** transforms target to result of function */
  def mapTarget(f: io.k8s.api.autoscaling.v2beta2.MetricTarget => io.k8s.api.autoscaling.v2beta2.MetricTarget) : PodsMetricSource = copy(target = f(target))
}

object PodsMetricSource {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2beta2.PodsMetricSource] = new Encoder[io.k8s.api.autoscaling.v2beta2.PodsMetricSource] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2beta2.PodsMetricSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metric", o.metric)
            .write("target", o.target)
            .build
        }
    }

    implicit val decoder: Decoder[PodsMetricSource] = new Decoder[PodsMetricSource] {
      def apply[T : Reader](t: T): Either[String, PodsMetricSource] = for {
          obj <- ObjectReader(t)
          metric <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricIdentifier]("metric")
          target <- obj.read[io.k8s.api.autoscaling.v2beta2.MetricTarget]("target")
      } yield PodsMetricSource (
          metric = metric,
          target = target
        )
    }
}

