package io.k8s.api.batch.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Job represents the configuration of a single job. */
final case class Job(
  status : Option[io.k8s.api.batch.v1.JobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.JobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "Job", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.batch.v1.JobStatus) : Job = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.batch.v1.JobStatus => io.k8s.api.batch.v1.JobStatus) : Job = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.JobSpec) : Job = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.JobSpec => io.k8s.api.batch.v1.JobSpec) : Job = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Job = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Job = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Job.encoder.apply(this)
}

object Job {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.Job] = new Encoder[io.k8s.api.batch.v1.Job] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.Job) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Job] = new Decoder[Job] {
      def apply[T : Reader](t: T): Either[String, Job] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.batch.v1.JobStatus]("status")
          spec <- obj.readOpt[io.k8s.api.batch.v1.JobSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Job (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

