package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** AttachedVolume describes a volume attached to a node */
final case class AttachedVolume(
  devicePath : String,
  name : String
) {

  /** Returns a new data with devicePath set to new value */
  def withDevicePath(value: String) : AttachedVolume = copy(devicePath = value)
  /** transforms devicePath to result of function */
  def mapDevicePath(f: String => String) : AttachedVolume = copy(devicePath = f(devicePath))

  /** Returns a new data with name set to new value */
  def withName(value: String) : AttachedVolume = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : AttachedVolume = copy(name = f(name))
}

object AttachedVolume {

    implicit val encoder : Encoder[io.k8s.api.core.v1.AttachedVolume] = new Encoder[io.k8s.api.core.v1.AttachedVolume] {
        def apply[T : Builder](o: io.k8s.api.core.v1.AttachedVolume) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("devicePath", o.devicePath)
            .write("name", o.name)
            .build
        }
    }

    implicit val decoder: Decoder[AttachedVolume] = new Decoder[AttachedVolume] {
      def apply[T : Reader](t: T): Either[String, AttachedVolume] = for {
          obj <- ObjectReader(t)
          devicePath <- obj.read[String]("devicePath")
          name <- obj.read[String]("name")
      } yield AttachedVolume (
          devicePath = devicePath,
          name = name
        )
    }
}

