package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ClientIPConfig represents the configurations of Client IP based session affinity. */
final case class ClientIPConfig(
  timeoutSeconds : Option[Int] = None
) {

  /** Returns a new data with timeoutSeconds set to new value */
  def withTimeoutSeconds(value: Int) : ClientIPConfig = copy(timeoutSeconds = Some(value))
  /** if timeoutSeconds has a value, transforms to the result of function*/
  def mapTimeoutSeconds(f: Int => Int) : ClientIPConfig = copy(timeoutSeconds = timeoutSeconds.map(f))
}

object ClientIPConfig {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ClientIPConfig] = new Encoder[io.k8s.api.core.v1.ClientIPConfig] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ClientIPConfig) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("timeoutSeconds", o.timeoutSeconds)
            .build
        }
    }

    implicit val decoder: Decoder[ClientIPConfig] = new Decoder[ClientIPConfig] {
      def apply[T : Reader](t: T): Either[String, ClientIPConfig] = for {
          obj <- ObjectReader(t)
          timeoutSeconds <- obj.readOpt[Int]("timeoutSeconds")
      } yield ClientIPConfig (
          timeoutSeconds = timeoutSeconds
        )
    }
}

