package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ExecAction describes a "run in container" action. */
final case class ExecAction(
  command : Option[Seq[String]] = None
) {

  /** Returns a new data with command set to new value */
  def withCommand(value: Seq[String]) : ExecAction = copy(command = Some(value))
  /** Appends new values to command */
  def addCommand(newValues: String*) : ExecAction = copy(command = Some(command.fold(newValues)(_ ++ newValues)))
  /** if command has a value, transforms to the result of function*/
  def mapCommand(f: Seq[String] => Seq[String]) : ExecAction = copy(command = command.map(f))
}

object ExecAction {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ExecAction] = new Encoder[io.k8s.api.core.v1.ExecAction] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ExecAction) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("command", o.command)
            .build
        }
    }

    implicit val decoder: Decoder[ExecAction] = new Decoder[ExecAction] {
      def apply[T : Reader](t: T): Either[String, ExecAction] = for {
          obj <- ObjectReader(t)
          command <- obj.readOpt[Seq[String]]("command")
      } yield ExecAction (
          command = command
        )
    }
}

