package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Local represents directly-attached storage with node affinity (Beta feature) */
final case class LocalVolumeSource(
  path : String,
  fsType : Option[String] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : LocalVolumeSource = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : LocalVolumeSource = copy(path = f(path))

  /** Returns a new data with fsType set to new value */
  def withFsType(value: String) : LocalVolumeSource = copy(fsType = Some(value))
  /** if fsType has a value, transforms to the result of function*/
  def mapFsType(f: String => String) : LocalVolumeSource = copy(fsType = fsType.map(f))
}

object LocalVolumeSource {

    implicit val encoder : Encoder[io.k8s.api.core.v1.LocalVolumeSource] = new Encoder[io.k8s.api.core.v1.LocalVolumeSource] {
        def apply[T : Builder](o: io.k8s.api.core.v1.LocalVolumeSource) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("path", o.path)
            .write("fsType", o.fsType)
            .build
        }
    }

    implicit val decoder: Decoder[LocalVolumeSource] = new Decoder[LocalVolumeSource] {
      def apply[T : Reader](t: T): Either[String, LocalVolumeSource] = for {
          obj <- ObjectReader(t)
          path <- obj.read[String]("path")
          fsType <- obj.readOpt[String]("fsType")
      } yield LocalVolumeSource (
          path = path,
          fsType = fsType
        )
    }
}

