package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeAddress contains information for the node's address. */
final case class NodeAddress(
  address : String,
  `type` : String
) {

  /** Returns a new data with address set to new value */
  def withAddress(value: String) : NodeAddress = copy(address = value)
  /** transforms address to result of function */
  def mapAddress(f: String => String) : NodeAddress = copy(address = f(address))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : NodeAddress = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : NodeAddress = copy(`type` = f(`type`))
}

object NodeAddress {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeAddress] = new Encoder[io.k8s.api.core.v1.NodeAddress] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeAddress) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("address", o.address)
            .write("type", o.`type`)
            .build
        }
    }

    implicit val decoder: Decoder[NodeAddress] = new Decoder[NodeAddress] {
      def apply[T : Reader](t: T): Either[String, NodeAddress] = for {
          obj <- ObjectReader(t)
          address <- obj.read[String]("address")
          `type` <- obj.read[String]("type")
      } yield NodeAddress (
          address = address,
          `type` = `type`
        )
    }
}

