package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ObjectFieldSelector selects an APIVersioned field of an object. */
final case class ObjectFieldSelector(
  fieldPath : String
) {

  /** Returns a new data with fieldPath set to new value */
  def withFieldPath(value: String) : ObjectFieldSelector = copy(fieldPath = value)
  /** transforms fieldPath to result of function */
  def mapFieldPath(f: String => String) : ObjectFieldSelector = copy(fieldPath = f(fieldPath))
}

object ObjectFieldSelector {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ObjectFieldSelector] = new Encoder[io.k8s.api.core.v1.ObjectFieldSelector] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ObjectFieldSelector) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("fieldPath", o.fieldPath)
            .build
        }
    }

    implicit val decoder: Decoder[ObjectFieldSelector] = new Decoder[ObjectFieldSelector] {
      def apply[T : Reader](t: T): Either[String, ObjectFieldSelector] = for {
          obj <- ObjectReader(t)
          fieldPath <- obj.read[String]("fieldPath")
      } yield ObjectFieldSelector (
          fieldPath = fieldPath
        )
    }
}

