package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** An empty preferred scheduling term matches all objects with implicit weight 0 (i.e. it's a no-op). A null preferred scheduling term matches no objects (i.e. is also a no-op). */
final case class PreferredSchedulingTerm(
  preference : io.k8s.api.core.v1.NodeSelectorTerm,
  weight : Int
) {

  /** Returns a new data with preference set to new value */
  def withPreference(value: io.k8s.api.core.v1.NodeSelectorTerm) : PreferredSchedulingTerm = copy(preference = value)
  /** transforms preference to result of function */
  def mapPreference(f: io.k8s.api.core.v1.NodeSelectorTerm => io.k8s.api.core.v1.NodeSelectorTerm) : PreferredSchedulingTerm = copy(preference = f(preference))

  /** Returns a new data with weight set to new value */
  def withWeight(value: Int) : PreferredSchedulingTerm = copy(weight = value)
  /** transforms weight to result of function */
  def mapWeight(f: Int => Int) : PreferredSchedulingTerm = copy(weight = f(weight))
}

object PreferredSchedulingTerm {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PreferredSchedulingTerm] = new Encoder[io.k8s.api.core.v1.PreferredSchedulingTerm] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PreferredSchedulingTerm) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("preference", o.preference)
            .write("weight", o.weight)
            .build
        }
    }

    implicit val decoder: Decoder[PreferredSchedulingTerm] = new Decoder[PreferredSchedulingTerm] {
      def apply[T : Reader](t: T): Either[String, PreferredSchedulingTerm] = for {
          obj <- ObjectReader(t)
          preference <- obj.read[io.k8s.api.core.v1.NodeSelectorTerm]("preference")
          weight <- obj.read[Int]("weight")
      } yield PreferredSchedulingTerm (
          preference = preference,
          weight = weight
        )
    }
}

