package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** ReplicationControllerCondition describes the state of a replication controller at a certain point. */
final case class ReplicationControllerCondition(
  status : String,
  `type` : String,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : ReplicationControllerCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : ReplicationControllerCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : ReplicationControllerCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : ReplicationControllerCondition = copy(`type` = f(`type`))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : ReplicationControllerCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : ReplicationControllerCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicationControllerCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : ReplicationControllerCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : ReplicationControllerCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : ReplicationControllerCondition = copy(message = message.map(f))
}

object ReplicationControllerCondition {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ReplicationControllerCondition] = new Encoder[io.k8s.api.core.v1.ReplicationControllerCondition] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ReplicationControllerCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit val decoder: Decoder[ReplicationControllerCondition] = new Decoder[ReplicationControllerCondition] {
      def apply[T : Reader](t: T): Either[String, ReplicationControllerCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield ReplicationControllerCondition (
          status = status,
          `type` = `type`,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

