package io.k8s.api.networking.v1alpha1

import dev.hnaderi.k8s.utils._

/** ClusterCIDRSpec defines the desired state of ClusterCIDR. */
final case class ClusterCIDRSpec(
  perNodeHostBits : Int,
  ipv4 : Option[String] = None,
  ipv6 : Option[String] = None,
  nodeSelector : Option[io.k8s.api.core.v1.NodeSelector] = None
) {

  /** Returns a new data with perNodeHostBits set to new value */
  def withPerNodeHostBits(value: Int) : ClusterCIDRSpec = copy(perNodeHostBits = value)
  /** transforms perNodeHostBits to result of function */
  def mapPerNodeHostBits(f: Int => Int) : ClusterCIDRSpec = copy(perNodeHostBits = f(perNodeHostBits))

  /** Returns a new data with ipv4 set to new value */
  def withIpv4(value: String) : ClusterCIDRSpec = copy(ipv4 = Some(value))
  /** if ipv4 has a value, transforms to the result of function*/
  def mapIpv4(f: String => String) : ClusterCIDRSpec = copy(ipv4 = ipv4.map(f))

  /** Returns a new data with ipv6 set to new value */
  def withIpv6(value: String) : ClusterCIDRSpec = copy(ipv6 = Some(value))
  /** if ipv6 has a value, transforms to the result of function*/
  def mapIpv6(f: String => String) : ClusterCIDRSpec = copy(ipv6 = ipv6.map(f))

  /** Returns a new data with nodeSelector set to new value */
  def withNodeSelector(value: io.k8s.api.core.v1.NodeSelector) : ClusterCIDRSpec = copy(nodeSelector = Some(value))
  /** if nodeSelector has a value, transforms to the result of function*/
  def mapNodeSelector(f: io.k8s.api.core.v1.NodeSelector => io.k8s.api.core.v1.NodeSelector) : ClusterCIDRSpec = copy(nodeSelector = nodeSelector.map(f))
}

object ClusterCIDRSpec {

    implicit val encoder : Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] = new Encoder[io.k8s.api.networking.v1alpha1.ClusterCIDRSpec] {
        def apply[T : Builder](o: io.k8s.api.networking.v1alpha1.ClusterCIDRSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("perNodeHostBits", o.perNodeHostBits)
            .write("ipv4", o.ipv4)
            .write("ipv6", o.ipv6)
            .write("nodeSelector", o.nodeSelector)
            .build
        }
    }

    implicit val decoder: Decoder[ClusterCIDRSpec] = new Decoder[ClusterCIDRSpec] {
      def apply[T : Reader](t: T): Either[String, ClusterCIDRSpec] = for {
          obj <- ObjectReader(t)
          perNodeHostBits <- obj.read[Int]("perNodeHostBits")
          ipv4 <- obj.readOpt[String]("ipv4")
          ipv6 <- obj.readOpt[String]("ipv6")
          nodeSelector <- obj.readOpt[io.k8s.api.core.v1.NodeSelector]("nodeSelector")
      } yield ClusterCIDRSpec (
          perNodeHostBits = perNodeHostBits,
          ipv4 = ipv4,
          ipv6 = ipv6,
          nodeSelector = nodeSelector
        )
    }
}

