package io.k8s.api.policy.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** PodDisruptionBudget is an object to define the max disruption that can be caused to a collection of pods */
final case class PodDisruptionBudget(
  status : Option[io.k8s.api.policy.v1.PodDisruptionBudgetStatus] = None,
  spec : Option[io.k8s.api.policy.v1.PodDisruptionBudgetSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("policy", "PodDisruptionBudget", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.policy.v1.PodDisruptionBudgetStatus) : PodDisruptionBudget = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.policy.v1.PodDisruptionBudgetStatus => io.k8s.api.policy.v1.PodDisruptionBudgetStatus) : PodDisruptionBudget = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.policy.v1.PodDisruptionBudgetSpec) : PodDisruptionBudget = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.policy.v1.PodDisruptionBudgetSpec => io.k8s.api.policy.v1.PodDisruptionBudgetSpec) : PodDisruptionBudget = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodDisruptionBudget = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PodDisruptionBudget = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = PodDisruptionBudget.encoder.apply(this)
}

object PodDisruptionBudget {

    implicit val encoder : Encoder[io.k8s.api.policy.v1.PodDisruptionBudget] = new Encoder[io.k8s.api.policy.v1.PodDisruptionBudget] {
        def apply[T : Builder](o: io.k8s.api.policy.v1.PodDisruptionBudget) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[PodDisruptionBudget] = new Decoder[PodDisruptionBudget] {
      def apply[T : Reader](t: T): Either[String, PodDisruptionBudget] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.policy.v1.PodDisruptionBudgetStatus]("status")
          spec <- obj.readOpt[io.k8s.api.policy.v1.PodDisruptionBudgetSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PodDisruptionBudget (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

