package io.k8s.api.rbac.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** RoleBindingList is a collection of RoleBindings */
final case class RoleBindingList(
  items : Seq[io.k8s.api.rbac.v1.RoleBinding],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("rbac.authorization.k8s.io", "RoleBindingList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.rbac.v1.RoleBinding]) : RoleBindingList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.rbac.v1.RoleBinding*) : RoleBindingList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.rbac.v1.RoleBinding] => Seq[io.k8s.api.rbac.v1.RoleBinding]) : RoleBindingList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleBindingList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : RoleBindingList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = RoleBindingList.encoder.apply(this)
}

object RoleBindingList {

    implicit val encoder : Encoder[io.k8s.api.rbac.v1.RoleBindingList] = new Encoder[io.k8s.api.rbac.v1.RoleBindingList] {
        def apply[T : Builder](o: io.k8s.api.rbac.v1.RoleBindingList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[RoleBindingList] = new Decoder[RoleBindingList] {
      def apply[T : Reader](t: T): Either[String, RoleBindingList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.rbac.v1.RoleBinding]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield RoleBindingList (
          items = items,
          metadata = metadata
        )
    }
}

