package io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CustomResourceDefinitionList is a list of CustomResourceDefinition objects. */
final case class CustomResourceDefinitionList(
  items : Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("apiextensions.k8s.io", "CustomResourceDefinitionList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition]) : CustomResourceDefinitionList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition*) : CustomResourceDefinitionList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition] => Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition]) : CustomResourceDefinitionList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CustomResourceDefinitionList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : CustomResourceDefinitionList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CustomResourceDefinitionList.encoder.apply(this)
}

object CustomResourceDefinitionList {

    implicit val encoder : Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList] = new Encoder[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList] {
        def apply[T : Builder](o: io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinitionList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[CustomResourceDefinitionList] = new Decoder[CustomResourceDefinitionList] {
      def apply[T : Reader](t: T): Either[String, CustomResourceDefinitionList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.apiextensions_apiserver.pkg.apis.apiextensions.v1.CustomResourceDefinition]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield CustomResourceDefinitionList (
          items = items,
          metadata = metadata
        )
    }
}

