package io.k8s.apimachinery.pkg.apis.meta.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** APIResourceList is a list of APIResource, it is used to expose the name of the resources supported in a specific group and version, and if the resource is namespaced. */
final case class APIResourceList(
  groupVersion : String,
  resources : Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]
) extends KObject {
  protected val _resourceKind = ResourceKind("", "APIResourceList", "v1")


  /** Returns a new data with groupVersion set to new value */
  def withGroupVersion(value: String) : APIResourceList = copy(groupVersion = value)
  /** transforms groupVersion to result of function */
  def mapGroupVersion(f: String => String) : APIResourceList = copy(groupVersion = f(groupVersion))

  /** Returns a new data with resources set to new value */
  def withResources(value: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]) : APIResourceList = copy(resources = value)
  /** Appends new values to resources */
  def addResources(newValues: io.k8s.apimachinery.pkg.apis.meta.v1.APIResource*) : APIResourceList = copy(resources = resources ++ newValues)
  /** transforms resources to result of function */
  def mapResources(f: Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource] => Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]) : APIResourceList = copy(resources = f(resources))

  override def foldTo[T : Builder] : T = APIResourceList.encoder.apply(this)
}

object APIResourceList {

    implicit val encoder : Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList] = new Encoder[io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList] {
        def apply[T : Builder](o: io.k8s.apimachinery.pkg.apis.meta.v1.APIResourceList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("groupVersion", o.groupVersion)
            .write("resources", o.resources)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[APIResourceList] = new Decoder[APIResourceList] {
      def apply[T : Reader](t: T): Either[String, APIResourceList] = for {
          obj <- ObjectReader(t)
          groupVersion <- obj.read[String]("groupVersion")
          resources <- obj.read[Seq[io.k8s.apimachinery.pkg.apis.meta.v1.APIResource]]("resources")
      } yield APIResourceList (
          groupVersion = groupVersion,
          resources = resources
        )
    }
}

