package io.k8s.api.admissionregistration.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** MutatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and may change the object. */
final case class MutatingWebhookConfiguration(
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None,
  webhooks : Option[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("admissionregistration.k8s.io", "MutatingWebhookConfiguration", "v1")


  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : MutatingWebhookConfiguration = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : MutatingWebhookConfiguration = copy(metadata = metadata.map(f))

  /** Returns a new data with webhooks set to new value */
  def withWebhooks(value: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]) : MutatingWebhookConfiguration = copy(webhooks = Some(value))
  /** Appends new values to webhooks */
  def addWebhooks(newValues: io.k8s.api.admissionregistration.v1.MutatingWebhook*) : MutatingWebhookConfiguration = copy(webhooks = Some(webhooks.fold(newValues)(_ ++ newValues)))
  /** if webhooks has a value, transforms to the result of function*/
  def mapWebhooks(f: Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook] => Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]) : MutatingWebhookConfiguration = copy(webhooks = webhooks.map(f))

  override def foldTo[T : Builder] : T = MutatingWebhookConfiguration.encoder.apply(this)
}

object MutatingWebhookConfiguration {

    implicit val encoder : Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] = new Encoder[io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration] {
        def apply[T : Builder](o: io.k8s.api.admissionregistration.v1.MutatingWebhookConfiguration) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("metadata", o.metadata)
            .write("webhooks", o.webhooks)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[MutatingWebhookConfiguration] = new Decoder[MutatingWebhookConfiguration] {
      def apply[T : Reader](t: T): Either[String, MutatingWebhookConfiguration] = for {
          obj <- ObjectReader(t)
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
          webhooks <- obj.readOpt[Seq[io.k8s.api.admissionregistration.v1.MutatingWebhook]]("webhooks")
      } yield MutatingWebhookConfiguration (
          metadata = metadata,
          webhooks = webhooks
        )
    }
}

