package io.k8s.api.apiserverinternal.v1alpha1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** A list of StorageVersions. */
final case class StorageVersionList(
  items : Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("internal.apiserver.k8s.io", "StorageVersionList", "v1alpha1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]) : StorageVersionList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.apiserverinternal.v1alpha1.StorageVersion*) : StorageVersionList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion] => Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]) : StorageVersionList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : StorageVersionList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = StorageVersionList.encoder.apply(this)
}

object StorageVersionList {

    implicit val encoder : Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList] = new Encoder[io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList] {
        def apply[T : Builder](o: io.k8s.api.apiserverinternal.v1alpha1.StorageVersionList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[StorageVersionList] = new Decoder[StorageVersionList] {
      def apply[T : Reader](t: T): Either[String, StorageVersionList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.apiserverinternal.v1alpha1.StorageVersion]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield StorageVersionList (
          items = items,
          metadata = metadata
        )
    }
}

