package io.k8s.api.authentication.v1

import dev.hnaderi.k8s.utils._

/** UserInfo holds the information about the user needed to implement the user.Info interface. */
final case class UserInfo(
  extra : Option[Map[String, Seq[String]]] = None,
  groups : Option[Seq[String]] = None,
  uid : Option[String] = None,
  username : Option[String] = None
) {

  /** Returns a new data with extra set to new value */
  def withExtra(value: Map[String, Seq[String]]) : UserInfo = copy(extra = Some(value))
  /** Adds new values to extra */
  def addExtra(newValues: (String, Seq[String])*) : UserInfo = copy(extra = Some(extra.fold(newValues.toMap)(_ ++ newValues)))
  /** if extra has a value, transforms to the result of function*/
  def mapExtra(f: Map[String, Seq[String]] => Map[String, Seq[String]]) : UserInfo = copy(extra = extra.map(f))

  /** Returns a new data with groups set to new value */
  def withGroups(value: Seq[String]) : UserInfo = copy(groups = Some(value))
  /** Appends new values to groups */
  def addGroups(newValues: String*) : UserInfo = copy(groups = Some(groups.fold(newValues)(_ ++ newValues)))
  /** if groups has a value, transforms to the result of function*/
  def mapGroups(f: Seq[String] => Seq[String]) : UserInfo = copy(groups = groups.map(f))

  /** Returns a new data with uid set to new value */
  def withUid(value: String) : UserInfo = copy(uid = Some(value))
  /** if uid has a value, transforms to the result of function*/
  def mapUid(f: String => String) : UserInfo = copy(uid = uid.map(f))

  /** Returns a new data with username set to new value */
  def withUsername(value: String) : UserInfo = copy(username = Some(value))
  /** if username has a value, transforms to the result of function*/
  def mapUsername(f: String => String) : UserInfo = copy(username = username.map(f))
}

object UserInfo {

    implicit val encoder : Encoder[io.k8s.api.authentication.v1.UserInfo] = new Encoder[io.k8s.api.authentication.v1.UserInfo] {
        def apply[T : Builder](o: io.k8s.api.authentication.v1.UserInfo) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("extra", o.extra)
            .write("groups", o.groups)
            .write("uid", o.uid)
            .write("username", o.username)
            .build
        }
    }

    implicit val decoder: Decoder[UserInfo] = new Decoder[UserInfo] {
      def apply[T : Reader](t: T): Either[String, UserInfo] = for {
          obj <- ObjectReader(t)
          extra <- obj.readOpt[Map[String, Seq[String]]]("extra")
          groups <- obj.readOpt[Seq[String]]("groups")
          uid <- obj.readOpt[String]("uid")
          username <- obj.readOpt[String]("username")
      } yield UserInfo (
          extra = extra,
          groups = groups,
          uid = uid,
          username = username
        )
    }
}

