package io.k8s.api.authorization.v1

import dev.hnaderi.k8s.utils._

/** SelfSubjectAccessReviewSpec is a description of the access request.  Exactly one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must be set */
final case class SelfSubjectAccessReviewSpec(
  nonResourceAttributes : Option[io.k8s.api.authorization.v1.NonResourceAttributes] = None,
  resourceAttributes : Option[io.k8s.api.authorization.v1.ResourceAttributes] = None
) {

  /** Returns a new data with nonResourceAttributes set to new value */
  def withNonResourceAttributes(value: io.k8s.api.authorization.v1.NonResourceAttributes) : SelfSubjectAccessReviewSpec = copy(nonResourceAttributes = Some(value))
  /** if nonResourceAttributes has a value, transforms to the result of function*/
  def mapNonResourceAttributes(f: io.k8s.api.authorization.v1.NonResourceAttributes => io.k8s.api.authorization.v1.NonResourceAttributes) : SelfSubjectAccessReviewSpec = copy(nonResourceAttributes = nonResourceAttributes.map(f))

  /** Returns a new data with resourceAttributes set to new value */
  def withResourceAttributes(value: io.k8s.api.authorization.v1.ResourceAttributes) : SelfSubjectAccessReviewSpec = copy(resourceAttributes = Some(value))
  /** if resourceAttributes has a value, transforms to the result of function*/
  def mapResourceAttributes(f: io.k8s.api.authorization.v1.ResourceAttributes => io.k8s.api.authorization.v1.ResourceAttributes) : SelfSubjectAccessReviewSpec = copy(resourceAttributes = resourceAttributes.map(f))
}

object SelfSubjectAccessReviewSpec {

    implicit val encoder : Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec] = new Encoder[io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec] {
        def apply[T : Builder](o: io.k8s.api.authorization.v1.SelfSubjectAccessReviewSpec) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("nonResourceAttributes", o.nonResourceAttributes)
            .write("resourceAttributes", o.resourceAttributes)
            .build
        }
    }

    implicit val decoder: Decoder[SelfSubjectAccessReviewSpec] = new Decoder[SelfSubjectAccessReviewSpec] {
      def apply[T : Reader](t: T): Either[String, SelfSubjectAccessReviewSpec] = for {
          obj <- ObjectReader(t)
          nonResourceAttributes <- obj.readOpt[io.k8s.api.authorization.v1.NonResourceAttributes]("nonResourceAttributes")
          resourceAttributes <- obj.readOpt[io.k8s.api.authorization.v1.ResourceAttributes]("resourceAttributes")
      } yield SelfSubjectAccessReviewSpec (
          nonResourceAttributes = nonResourceAttributes,
          resourceAttributes = resourceAttributes
        )
    }
}

