package io.k8s.api.autoscaling.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** Scale represents a scaling request for a resource. */
final case class Scale(
  status : Option[io.k8s.api.autoscaling.v1.ScaleStatus] = None,
  spec : Option[io.k8s.api.autoscaling.v1.ScaleSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("autoscaling", "Scale", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.autoscaling.v1.ScaleStatus) : Scale = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.autoscaling.v1.ScaleStatus => io.k8s.api.autoscaling.v1.ScaleStatus) : Scale = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.autoscaling.v1.ScaleSpec) : Scale = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.autoscaling.v1.ScaleSpec => io.k8s.api.autoscaling.v1.ScaleSpec) : Scale = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Scale = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : Scale = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = Scale.encoder.apply(this)
}

object Scale {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v1.Scale] = new Encoder[io.k8s.api.autoscaling.v1.Scale] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v1.Scale) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[Scale] = new Decoder[Scale] {
      def apply[T : Reader](t: T): Either[String, Scale] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.autoscaling.v1.ScaleStatus]("status")
          spec <- obj.readOpt[io.k8s.api.autoscaling.v1.ScaleSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield Scale (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

