package io.k8s.api.autoscaling.v2

import dev.hnaderi.k8s.utils._

/** HorizontalPodAutoscalerBehavior configures the scaling behavior of the target in both Up and Down directions (scaleUp and scaleDown fields respectively). */
final case class HorizontalPodAutoscalerBehavior(
  scaleDown : Option[io.k8s.api.autoscaling.v2.HPAScalingRules] = None,
  scaleUp : Option[io.k8s.api.autoscaling.v2.HPAScalingRules] = None
) {

  /** Returns a new data with scaleDown set to new value */
  def withScaleDown(value: io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleDown = Some(value))
  /** if scaleDown has a value, transforms to the result of function*/
  def mapScaleDown(f: io.k8s.api.autoscaling.v2.HPAScalingRules => io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleDown = scaleDown.map(f))

  /** Returns a new data with scaleUp set to new value */
  def withScaleUp(value: io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleUp = Some(value))
  /** if scaleUp has a value, transforms to the result of function*/
  def mapScaleUp(f: io.k8s.api.autoscaling.v2.HPAScalingRules => io.k8s.api.autoscaling.v2.HPAScalingRules) : HorizontalPodAutoscalerBehavior = copy(scaleUp = scaleUp.map(f))
}

object HorizontalPodAutoscalerBehavior {

    implicit val encoder : Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] = new Encoder[io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior] {
        def apply[T : Builder](o: io.k8s.api.autoscaling.v2.HorizontalPodAutoscalerBehavior) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("scaleDown", o.scaleDown)
            .write("scaleUp", o.scaleUp)
            .build
        }
    }

    implicit val decoder: Decoder[HorizontalPodAutoscalerBehavior] = new Decoder[HorizontalPodAutoscalerBehavior] {
      def apply[T : Reader](t: T): Either[String, HorizontalPodAutoscalerBehavior] = for {
          obj <- ObjectReader(t)
          scaleDown <- obj.readOpt[io.k8s.api.autoscaling.v2.HPAScalingRules]("scaleDown")
          scaleUp <- obj.readOpt[io.k8s.api.autoscaling.v2.HPAScalingRules]("scaleUp")
      } yield HorizontalPodAutoscalerBehavior (
          scaleDown = scaleDown,
          scaleUp = scaleUp
        )
    }
}

