package io.k8s.api.batch.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** CronJob represents the configuration of a single cron job. */
final case class CronJob(
  status : Option[io.k8s.api.batch.v1.CronJobStatus] = None,
  spec : Option[io.k8s.api.batch.v1.CronJobSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "CronJob", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.batch.v1.CronJobStatus) : CronJob = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.batch.v1.CronJobStatus => io.k8s.api.batch.v1.CronJobStatus) : CronJob = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.batch.v1.CronJobSpec) : CronJob = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.batch.v1.CronJobSpec => io.k8s.api.batch.v1.CronJobSpec) : CronJob = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CronJob = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : CronJob = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = CronJob.encoder.apply(this)
}

object CronJob {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.CronJob] = new Encoder[io.k8s.api.batch.v1.CronJob] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.CronJob) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[CronJob] = new Decoder[CronJob] {
      def apply[T : Reader](t: T): Either[String, CronJob] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.batch.v1.CronJobStatus]("status")
          spec <- obj.readOpt[io.k8s.api.batch.v1.CronJobSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield CronJob (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

