package io.k8s.api.batch.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** JobList is a collection of jobs. */
final case class JobList(
  items : Seq[io.k8s.api.batch.v1.Job],
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("batch", "JobList", "v1")


  /** Returns a new data with items set to new value */
  def withItems(value: Seq[io.k8s.api.batch.v1.Job]) : JobList = copy(items = value)
  /** Appends new values to items */
  def addItems(newValues: io.k8s.api.batch.v1.Job*) : JobList = copy(items = items ++ newValues)
  /** transforms items to result of function */
  def mapItems(f: Seq[io.k8s.api.batch.v1.Job] => Seq[io.k8s.api.batch.v1.Job]) : JobList = copy(items = f(items))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : JobList = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta) : JobList = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = JobList.encoder.apply(this)
}

object JobList {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.JobList] = new Encoder[io.k8s.api.batch.v1.JobList] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.JobList) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("items", o.items)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[JobList] = new Decoder[JobList] {
      def apply[T : Reader](t: T): Either[String, JobList] = for {
          obj <- ObjectReader(t)
          items <- obj.read[Seq[io.k8s.api.batch.v1.Job]]("items")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ListMeta]("metadata")
      } yield JobList (
          items = items,
          metadata = metadata
        )
    }
}

