package io.k8s.api.batch.v1

import dev.hnaderi.k8s.utils._

/** UncountedTerminatedPods holds UIDs of Pods that have terminated but haven't been accounted in Job status counters. */
final case class UncountedTerminatedPods(
  failed : Option[Seq[String]] = None,
  succeeded : Option[Seq[String]] = None
) {

  /** Returns a new data with failed set to new value */
  def withFailed(value: Seq[String]) : UncountedTerminatedPods = copy(failed = Some(value))
  /** Appends new values to failed */
  def addFailed(newValues: String*) : UncountedTerminatedPods = copy(failed = Some(failed.fold(newValues)(_ ++ newValues)))
  /** if failed has a value, transforms to the result of function*/
  def mapFailed(f: Seq[String] => Seq[String]) : UncountedTerminatedPods = copy(failed = failed.map(f))

  /** Returns a new data with succeeded set to new value */
  def withSucceeded(value: Seq[String]) : UncountedTerminatedPods = copy(succeeded = Some(value))
  /** Appends new values to succeeded */
  def addSucceeded(newValues: String*) : UncountedTerminatedPods = copy(succeeded = Some(succeeded.fold(newValues)(_ ++ newValues)))
  /** if succeeded has a value, transforms to the result of function*/
  def mapSucceeded(f: Seq[String] => Seq[String]) : UncountedTerminatedPods = copy(succeeded = succeeded.map(f))
}

object UncountedTerminatedPods {

    implicit val encoder : Encoder[io.k8s.api.batch.v1.UncountedTerminatedPods] = new Encoder[io.k8s.api.batch.v1.UncountedTerminatedPods] {
        def apply[T : Builder](o: io.k8s.api.batch.v1.UncountedTerminatedPods) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("failed", o.failed)
            .write("succeeded", o.succeeded)
            .build
        }
    }

    implicit val decoder: Decoder[UncountedTerminatedPods] = new Decoder[UncountedTerminatedPods] {
      def apply[T : Reader](t: T): Either[String, UncountedTerminatedPods] = for {
          obj <- ObjectReader(t)
          failed <- obj.readOpt[Seq[String]]("failed")
          succeeded <- obj.readOpt[Seq[String]]("succeeded")
      } yield UncountedTerminatedPods (
          failed = failed,
          succeeded = succeeded
        )
    }
}

