package io.k8s.api.certificates.v1

import dev.hnaderi.k8s.utils._

/** CertificateSigningRequestCondition describes a condition of a CertificateSigningRequest object */
final case class CertificateSigningRequestCondition(
  status : String,
  `type` : String,
  lastUpdateTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  reason : Option[String] = None,
  lastTransitionTime : Option[io.k8s.apimachinery.pkg.apis.meta.v1.Time] = None,
  message : Option[String] = None
) {

  /** Returns a new data with status set to new value */
  def withStatus(value: String) : CertificateSigningRequestCondition = copy(status = value)
  /** transforms status to result of function */
  def mapStatus(f: String => String) : CertificateSigningRequestCondition = copy(status = f(status))

  /** Returns a new data with `type` set to new value */
  def withType(value: String) : CertificateSigningRequestCondition = copy(`type` = value)
  /** transforms `type` to result of function */
  def mapType(f: String => String) : CertificateSigningRequestCondition = copy(`type` = f(`type`))

  /** Returns a new data with lastUpdateTime set to new value */
  def withLastUpdateTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CertificateSigningRequestCondition = copy(lastUpdateTime = Some(value))
  /** if lastUpdateTime has a value, transforms to the result of function*/
  def mapLastUpdateTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CertificateSigningRequestCondition = copy(lastUpdateTime = lastUpdateTime.map(f))

  /** Returns a new data with reason set to new value */
  def withReason(value: String) : CertificateSigningRequestCondition = copy(reason = Some(value))
  /** if reason has a value, transforms to the result of function*/
  def mapReason(f: String => String) : CertificateSigningRequestCondition = copy(reason = reason.map(f))

  /** Returns a new data with lastTransitionTime set to new value */
  def withLastTransitionTime(value: io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CertificateSigningRequestCondition = copy(lastTransitionTime = Some(value))
  /** if lastTransitionTime has a value, transforms to the result of function*/
  def mapLastTransitionTime(f: io.k8s.apimachinery.pkg.apis.meta.v1.Time => io.k8s.apimachinery.pkg.apis.meta.v1.Time) : CertificateSigningRequestCondition = copy(lastTransitionTime = lastTransitionTime.map(f))

  /** Returns a new data with message set to new value */
  def withMessage(value: String) : CertificateSigningRequestCondition = copy(message = Some(value))
  /** if message has a value, transforms to the result of function*/
  def mapMessage(f: String => String) : CertificateSigningRequestCondition = copy(message = message.map(f))
}

object CertificateSigningRequestCondition {

    implicit val encoder : Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] = new Encoder[io.k8s.api.certificates.v1.CertificateSigningRequestCondition] {
        def apply[T : Builder](o: io.k8s.api.certificates.v1.CertificateSigningRequestCondition) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("type", o.`type`)
            .write("lastUpdateTime", o.lastUpdateTime)
            .write("reason", o.reason)
            .write("lastTransitionTime", o.lastTransitionTime)
            .write("message", o.message)
            .build
        }
    }

    implicit val decoder: Decoder[CertificateSigningRequestCondition] = new Decoder[CertificateSigningRequestCondition] {
      def apply[T : Reader](t: T): Either[String, CertificateSigningRequestCondition] = for {
          obj <- ObjectReader(t)
          status <- obj.read[String]("status")
          `type` <- obj.read[String]("type")
          lastUpdateTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastUpdateTime")
          reason <- obj.readOpt[String]("reason")
          lastTransitionTime <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.Time]("lastTransitionTime")
          message <- obj.readOpt[String]("message")
      } yield CertificateSigningRequestCondition (
          status = status,
          `type` = `type`,
          lastUpdateTime = lastUpdateTime,
          reason = reason,
          lastTransitionTime = lastTransitionTime,
          message = message
        )
    }
}

