package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** DownwardAPIVolumeFile represents information to create the file containing the pod field */
final case class DownwardAPIVolumeFile(
  path : String,
  fieldRef : Option[io.k8s.api.core.v1.ObjectFieldSelector] = None,
  mode : Option[Int] = None,
  resourceFieldRef : Option[io.k8s.api.core.v1.ResourceFieldSelector] = None
) {

  /** Returns a new data with path set to new value */
  def withPath(value: String) : DownwardAPIVolumeFile = copy(path = value)
  /** transforms path to result of function */
  def mapPath(f: String => String) : DownwardAPIVolumeFile = copy(path = f(path))

  /** Returns a new data with fieldRef set to new value */
  def withFieldRef(value: io.k8s.api.core.v1.ObjectFieldSelector) : DownwardAPIVolumeFile = copy(fieldRef = Some(value))
  /** if fieldRef has a value, transforms to the result of function*/
  def mapFieldRef(f: io.k8s.api.core.v1.ObjectFieldSelector => io.k8s.api.core.v1.ObjectFieldSelector) : DownwardAPIVolumeFile = copy(fieldRef = fieldRef.map(f))

  /** Returns a new data with mode set to new value */
  def withMode(value: Int) : DownwardAPIVolumeFile = copy(mode = Some(value))
  /** if mode has a value, transforms to the result of function*/
  def mapMode(f: Int => Int) : DownwardAPIVolumeFile = copy(mode = mode.map(f))

  /** Returns a new data with resourceFieldRef set to new value */
  def withResourceFieldRef(value: io.k8s.api.core.v1.ResourceFieldSelector) : DownwardAPIVolumeFile = copy(resourceFieldRef = Some(value))
  /** if resourceFieldRef has a value, transforms to the result of function*/
  def mapResourceFieldRef(f: io.k8s.api.core.v1.ResourceFieldSelector => io.k8s.api.core.v1.ResourceFieldSelector) : DownwardAPIVolumeFile = copy(resourceFieldRef = resourceFieldRef.map(f))
}

object DownwardAPIVolumeFile {

    implicit val encoder : Encoder[io.k8s.api.core.v1.DownwardAPIVolumeFile] = new Encoder[io.k8s.api.core.v1.DownwardAPIVolumeFile] {
        def apply[T : Builder](o: io.k8s.api.core.v1.DownwardAPIVolumeFile) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("path", o.path)
            .write("fieldRef", o.fieldRef)
            .write("mode", o.mode)
            .write("resourceFieldRef", o.resourceFieldRef)
            .build
        }
    }

    implicit val decoder: Decoder[DownwardAPIVolumeFile] = new Decoder[DownwardAPIVolumeFile] {
      def apply[T : Reader](t: T): Either[String, DownwardAPIVolumeFile] = for {
          obj <- ObjectReader(t)
          path <- obj.read[String]("path")
          fieldRef <- obj.readOpt[io.k8s.api.core.v1.ObjectFieldSelector]("fieldRef")
          mode <- obj.readOpt[Int]("mode")
          resourceFieldRef <- obj.readOpt[io.k8s.api.core.v1.ResourceFieldSelector]("resourceFieldRef")
      } yield DownwardAPIVolumeFile (
          path = path,
          fieldRef = fieldRef,
          mode = mode,
          resourceFieldRef = resourceFieldRef
        )
    }
}

