package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** HTTPHeader describes a custom header to be used in HTTP probes */
final case class HTTPHeader(
  name : String,
  value : String
) {

  /** Returns a new data with name set to new value */
  def withName(value: String) : HTTPHeader = copy(name = value)
  /** transforms name to result of function */
  def mapName(f: String => String) : HTTPHeader = copy(name = f(name))

  /** Returns a new data with value set to new value */
  def withValue(value: String) : HTTPHeader = copy(value = value)
  /** transforms value to result of function */
  def mapValue(f: String => String) : HTTPHeader = copy(value = f(value))
}

object HTTPHeader {

    implicit val encoder : Encoder[io.k8s.api.core.v1.HTTPHeader] = new Encoder[io.k8s.api.core.v1.HTTPHeader] {
        def apply[T : Builder](o: io.k8s.api.core.v1.HTTPHeader) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("name", o.name)
            .write("value", o.value)
            .build
        }
    }

    implicit val decoder: Decoder[HTTPHeader] = new Decoder[HTTPHeader] {
      def apply[T : Reader](t: T): Either[String, HTTPHeader] = for {
          obj <- ObjectReader(t)
          name <- obj.read[String]("name")
          value <- obj.read[String]("value")
      } yield HTTPHeader (
          name = name,
          value = value
        )
    }
}

