package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** NodeDaemonEndpoints lists ports opened by daemons running on the Node. */
final case class NodeDaemonEndpoints(
  kubeletEndpoint : Option[io.k8s.api.core.v1.DaemonEndpoint] = None
) {

  /** Returns a new data with kubeletEndpoint set to new value */
  def withKubeletEndpoint(value: io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = Some(value))
  /** if kubeletEndpoint has a value, transforms to the result of function*/
  def mapKubeletEndpoint(f: io.k8s.api.core.v1.DaemonEndpoint => io.k8s.api.core.v1.DaemonEndpoint) : NodeDaemonEndpoints = copy(kubeletEndpoint = kubeletEndpoint.map(f))
}

object NodeDaemonEndpoints {

    implicit val encoder : Encoder[io.k8s.api.core.v1.NodeDaemonEndpoints] = new Encoder[io.k8s.api.core.v1.NodeDaemonEndpoints] {
        def apply[T : Builder](o: io.k8s.api.core.v1.NodeDaemonEndpoints) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("kubeletEndpoint", o.kubeletEndpoint)
            .build
        }
    }

    implicit val decoder: Decoder[NodeDaemonEndpoints] = new Decoder[NodeDaemonEndpoints] {
      def apply[T : Reader](t: T): Either[String, NodeDaemonEndpoints] = for {
          obj <- ObjectReader(t)
          kubeletEndpoint <- obj.readOpt[io.k8s.api.core.v1.DaemonEndpoint]("kubeletEndpoint")
      } yield NodeDaemonEndpoints (
          kubeletEndpoint = kubeletEndpoint
        )
    }
}

