package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaimStatus is the current status of a persistent volume claim. */
final case class PersistentVolumeClaimStatus(
  conditions : Option[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]] = None,
  accessModes : Option[Seq[String]] = None,
  phase : Option[String] = None,
  resizeStatus : Option[String] = None,
  allocatedResources : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None,
  capacity : Option[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]] = None
) {

  /** Returns a new data with conditions set to new value */
  def withConditions(value: Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]) : PersistentVolumeClaimStatus = copy(conditions = Some(value))
  /** Appends new values to conditions */
  def addConditions(newValues: io.k8s.api.core.v1.PersistentVolumeClaimCondition*) : PersistentVolumeClaimStatus = copy(conditions = Some(conditions.fold(newValues)(_ ++ newValues)))
  /** if conditions has a value, transforms to the result of function*/
  def mapConditions(f: Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition] => Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]) : PersistentVolumeClaimStatus = copy(conditions = conditions.map(f))

  /** Returns a new data with accessModes set to new value */
  def withAccessModes(value: Seq[String]) : PersistentVolumeClaimStatus = copy(accessModes = Some(value))
  /** Appends new values to accessModes */
  def addAccessModes(newValues: String*) : PersistentVolumeClaimStatus = copy(accessModes = Some(accessModes.fold(newValues)(_ ++ newValues)))
  /** if accessModes has a value, transforms to the result of function*/
  def mapAccessModes(f: Seq[String] => Seq[String]) : PersistentVolumeClaimStatus = copy(accessModes = accessModes.map(f))

  /** Returns a new data with phase set to new value */
  def withPhase(value: String) : PersistentVolumeClaimStatus = copy(phase = Some(value))
  /** if phase has a value, transforms to the result of function*/
  def mapPhase(f: String => String) : PersistentVolumeClaimStatus = copy(phase = phase.map(f))

  /** Returns a new data with resizeStatus set to new value */
  def withResizeStatus(value: String) : PersistentVolumeClaimStatus = copy(resizeStatus = Some(value))
  /** if resizeStatus has a value, transforms to the result of function*/
  def mapResizeStatus(f: String => String) : PersistentVolumeClaimStatus = copy(resizeStatus = resizeStatus.map(f))

  /** Returns a new data with allocatedResources set to new value */
  def withAllocatedResources(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(allocatedResources = Some(value))
  /** Adds new values to allocatedResources */
  def addAllocatedResources(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeClaimStatus = copy(allocatedResources = Some(allocatedResources.fold(newValues.toMap)(_ ++ newValues)))
  /** if allocatedResources has a value, transforms to the result of function*/
  def mapAllocatedResources(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(allocatedResources = allocatedResources.map(f))

  /** Returns a new data with capacity set to new value */
  def withCapacity(value: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(capacity = Some(value))
  /** Adds new values to capacity */
  def addCapacity(newValues: (String, io.k8s.apimachinery.pkg.api.resource.Quantity)*) : PersistentVolumeClaimStatus = copy(capacity = Some(capacity.fold(newValues.toMap)(_ ++ newValues)))
  /** if capacity has a value, transforms to the result of function*/
  def mapCapacity(f: Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity] => Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]) : PersistentVolumeClaimStatus = copy(capacity = capacity.map(f))
}

object PersistentVolumeClaimStatus {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimStatus] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaimStatus] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PersistentVolumeClaimStatus) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("conditions", o.conditions)
            .write("accessModes", o.accessModes)
            .write("phase", o.phase)
            .write("resizeStatus", o.resizeStatus)
            .write("allocatedResources", o.allocatedResources)
            .write("capacity", o.capacity)
            .build
        }
    }

    implicit val decoder: Decoder[PersistentVolumeClaimStatus] = new Decoder[PersistentVolumeClaimStatus] {
      def apply[T : Reader](t: T): Either[String, PersistentVolumeClaimStatus] = for {
          obj <- ObjectReader(t)
          conditions <- obj.readOpt[Seq[io.k8s.api.core.v1.PersistentVolumeClaimCondition]]("conditions")
          accessModes <- obj.readOpt[Seq[String]]("accessModes")
          phase <- obj.readOpt[String]("phase")
          resizeStatus <- obj.readOpt[String]("resizeStatus")
          allocatedResources <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("allocatedResources")
          capacity <- obj.readOpt[Map[String, io.k8s.apimachinery.pkg.api.resource.Quantity]]("capacity")
      } yield PersistentVolumeClaimStatus (
          conditions = conditions,
          accessModes = accessModes,
          phase = phase,
          resizeStatus = resizeStatus,
          allocatedResources = allocatedResources,
          capacity = capacity
        )
    }
}

