package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** PersistentVolumeClaimTemplate is used to produce PersistentVolumeClaim objects as part of an EphemeralVolumeSource. */
final case class PersistentVolumeClaimTemplate(
  spec : io.k8s.api.core.v1.PersistentVolumeClaimSpec,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) {

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaimTemplate = copy(spec = value)
  /** transforms spec to result of function */
  def mapSpec(f: io.k8s.api.core.v1.PersistentVolumeClaimSpec => io.k8s.api.core.v1.PersistentVolumeClaimSpec) : PersistentVolumeClaimTemplate = copy(spec = f(spec))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaimTemplate = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : PersistentVolumeClaimTemplate = copy(metadata = metadata.map(f))
}

object PersistentVolumeClaimTemplate {

    implicit val encoder : Encoder[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] = new Encoder[io.k8s.api.core.v1.PersistentVolumeClaimTemplate] {
        def apply[T : Builder](o: io.k8s.api.core.v1.PersistentVolumeClaimTemplate) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .build
        }
    }

    implicit val decoder: Decoder[PersistentVolumeClaimTemplate] = new Decoder[PersistentVolumeClaimTemplate] {
      def apply[T : Reader](t: T): Either[String, PersistentVolumeClaimTemplate] = for {
          obj <- ObjectReader(t)
          spec <- obj.read[io.k8s.api.core.v1.PersistentVolumeClaimSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield PersistentVolumeClaimTemplate (
          spec = spec,
          metadata = metadata
        )
    }
}

