package io.k8s.api.core.v1

import dev.hnaderi.k8s.utils._

/** Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic. */
final case class Probe(
  timeoutSeconds : Option[Int] = None,
  grpc : Option[io.k8s.api.core.v1.GRPCAction] = None,
  tcpSocket : Option[io.k8s.api.core.v1.TCPSocketAction] = None,
  initialDelaySeconds : Option[Int] = None,
  failureThreshold : Option[Int] = None,
  httpGet : Option[io.k8s.api.core.v1.HTTPGetAction] = None,
  terminationGracePeriodSeconds : Option[Int] = None,
  exec : Option[io.k8s.api.core.v1.ExecAction] = None,
  periodSeconds : Option[Int] = None,
  successThreshold : Option[Int] = None
) {

  /** Returns a new data with timeoutSeconds set to new value */
  def withTimeoutSeconds(value: Int) : Probe = copy(timeoutSeconds = Some(value))
  /** if timeoutSeconds has a value, transforms to the result of function*/
  def mapTimeoutSeconds(f: Int => Int) : Probe = copy(timeoutSeconds = timeoutSeconds.map(f))

  /** Returns a new data with grpc set to new value */
  def withGrpc(value: io.k8s.api.core.v1.GRPCAction) : Probe = copy(grpc = Some(value))
  /** if grpc has a value, transforms to the result of function*/
  def mapGrpc(f: io.k8s.api.core.v1.GRPCAction => io.k8s.api.core.v1.GRPCAction) : Probe = copy(grpc = grpc.map(f))

  /** Returns a new data with tcpSocket set to new value */
  def withTcpSocket(value: io.k8s.api.core.v1.TCPSocketAction) : Probe = copy(tcpSocket = Some(value))
  /** if tcpSocket has a value, transforms to the result of function*/
  def mapTcpSocket(f: io.k8s.api.core.v1.TCPSocketAction => io.k8s.api.core.v1.TCPSocketAction) : Probe = copy(tcpSocket = tcpSocket.map(f))

  /** Returns a new data with initialDelaySeconds set to new value */
  def withInitialDelaySeconds(value: Int) : Probe = copy(initialDelaySeconds = Some(value))
  /** if initialDelaySeconds has a value, transforms to the result of function*/
  def mapInitialDelaySeconds(f: Int => Int) : Probe = copy(initialDelaySeconds = initialDelaySeconds.map(f))

  /** Returns a new data with failureThreshold set to new value */
  def withFailureThreshold(value: Int) : Probe = copy(failureThreshold = Some(value))
  /** if failureThreshold has a value, transforms to the result of function*/
  def mapFailureThreshold(f: Int => Int) : Probe = copy(failureThreshold = failureThreshold.map(f))

  /** Returns a new data with httpGet set to new value */
  def withHttpGet(value: io.k8s.api.core.v1.HTTPGetAction) : Probe = copy(httpGet = Some(value))
  /** if httpGet has a value, transforms to the result of function*/
  def mapHttpGet(f: io.k8s.api.core.v1.HTTPGetAction => io.k8s.api.core.v1.HTTPGetAction) : Probe = copy(httpGet = httpGet.map(f))

  /** Returns a new data with terminationGracePeriodSeconds set to new value */
  def withTerminationGracePeriodSeconds(value: Int) : Probe = copy(terminationGracePeriodSeconds = Some(value))
  /** if terminationGracePeriodSeconds has a value, transforms to the result of function*/
  def mapTerminationGracePeriodSeconds(f: Int => Int) : Probe = copy(terminationGracePeriodSeconds = terminationGracePeriodSeconds.map(f))

  /** Returns a new data with exec set to new value */
  def withExec(value: io.k8s.api.core.v1.ExecAction) : Probe = copy(exec = Some(value))
  /** if exec has a value, transforms to the result of function*/
  def mapExec(f: io.k8s.api.core.v1.ExecAction => io.k8s.api.core.v1.ExecAction) : Probe = copy(exec = exec.map(f))

  /** Returns a new data with periodSeconds set to new value */
  def withPeriodSeconds(value: Int) : Probe = copy(periodSeconds = Some(value))
  /** if periodSeconds has a value, transforms to the result of function*/
  def mapPeriodSeconds(f: Int => Int) : Probe = copy(periodSeconds = periodSeconds.map(f))

  /** Returns a new data with successThreshold set to new value */
  def withSuccessThreshold(value: Int) : Probe = copy(successThreshold = Some(value))
  /** if successThreshold has a value, transforms to the result of function*/
  def mapSuccessThreshold(f: Int => Int) : Probe = copy(successThreshold = successThreshold.map(f))
}

object Probe {

    implicit val encoder : Encoder[io.k8s.api.core.v1.Probe] = new Encoder[io.k8s.api.core.v1.Probe] {
        def apply[T : Builder](o: io.k8s.api.core.v1.Probe) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("timeoutSeconds", o.timeoutSeconds)
            .write("grpc", o.grpc)
            .write("tcpSocket", o.tcpSocket)
            .write("initialDelaySeconds", o.initialDelaySeconds)
            .write("failureThreshold", o.failureThreshold)
            .write("httpGet", o.httpGet)
            .write("terminationGracePeriodSeconds", o.terminationGracePeriodSeconds)
            .write("exec", o.exec)
            .write("periodSeconds", o.periodSeconds)
            .write("successThreshold", o.successThreshold)
            .build
        }
    }

    implicit val decoder: Decoder[Probe] = new Decoder[Probe] {
      def apply[T : Reader](t: T): Either[String, Probe] = for {
          obj <- ObjectReader(t)
          timeoutSeconds <- obj.readOpt[Int]("timeoutSeconds")
          grpc <- obj.readOpt[io.k8s.api.core.v1.GRPCAction]("grpc")
          tcpSocket <- obj.readOpt[io.k8s.api.core.v1.TCPSocketAction]("tcpSocket")
          initialDelaySeconds <- obj.readOpt[Int]("initialDelaySeconds")
          failureThreshold <- obj.readOpt[Int]("failureThreshold")
          httpGet <- obj.readOpt[io.k8s.api.core.v1.HTTPGetAction]("httpGet")
          terminationGracePeriodSeconds <- obj.readOpt[Int]("terminationGracePeriodSeconds")
          exec <- obj.readOpt[io.k8s.api.core.v1.ExecAction]("exec")
          periodSeconds <- obj.readOpt[Int]("periodSeconds")
          successThreshold <- obj.readOpt[Int]("successThreshold")
      } yield Probe (
          timeoutSeconds = timeoutSeconds,
          grpc = grpc,
          tcpSocket = tcpSocket,
          initialDelaySeconds = initialDelaySeconds,
          failureThreshold = failureThreshold,
          httpGet = httpGet,
          terminationGracePeriodSeconds = terminationGracePeriodSeconds,
          exec = exec,
          periodSeconds = periodSeconds,
          successThreshold = successThreshold
        )
    }
}

