package io.k8s.api.core.v1

import dev.hnaderi.k8s._
import dev.hnaderi.k8s.utils._

/** ReplicationController represents the configuration of a replication controller. */
final case class ReplicationController(
  status : Option[io.k8s.api.core.v1.ReplicationControllerStatus] = None,
  spec : Option[io.k8s.api.core.v1.ReplicationControllerSpec] = None,
  metadata : Option[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta] = None
) extends KObject {
  protected val _resourceKind = ResourceKind("", "ReplicationController", "v1")


  /** Returns a new data with status set to new value */
  def withStatus(value: io.k8s.api.core.v1.ReplicationControllerStatus) : ReplicationController = copy(status = Some(value))
  /** if status has a value, transforms to the result of function*/
  def mapStatus(f: io.k8s.api.core.v1.ReplicationControllerStatus => io.k8s.api.core.v1.ReplicationControllerStatus) : ReplicationController = copy(status = status.map(f))

  /** Returns a new data with spec set to new value */
  def withSpec(value: io.k8s.api.core.v1.ReplicationControllerSpec) : ReplicationController = copy(spec = Some(value))
  /** if spec has a value, transforms to the result of function*/
  def mapSpec(f: io.k8s.api.core.v1.ReplicationControllerSpec => io.k8s.api.core.v1.ReplicationControllerSpec) : ReplicationController = copy(spec = spec.map(f))

  /** Returns a new data with metadata set to new value */
  def withMetadata(value: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicationController = copy(metadata = Some(value))
  /** if metadata has a value, transforms to the result of function*/
  def mapMetadata(f: io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta => io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta) : ReplicationController = copy(metadata = metadata.map(f))

  override def foldTo[T : Builder] : T = ReplicationController.encoder.apply(this)
}

object ReplicationController {

    implicit val encoder : Encoder[io.k8s.api.core.v1.ReplicationController] = new Encoder[io.k8s.api.core.v1.ReplicationController] {
        def apply[T : Builder](o: io.k8s.api.core.v1.ReplicationController) : T = {
          val obj = ObjectWriter[T]()
          obj
            .write("status", o.status)
            .write("spec", o.spec)
            .write("metadata", o.metadata)
            .write("kind", o.kind)
            .write("apiVersion", o.apiVersion)
            .build
        }
    }

    implicit val decoder: Decoder[ReplicationController] = new Decoder[ReplicationController] {
      def apply[T : Reader](t: T): Either[String, ReplicationController] = for {
          obj <- ObjectReader(t)
          status <- obj.readOpt[io.k8s.api.core.v1.ReplicationControllerStatus]("status")
          spec <- obj.readOpt[io.k8s.api.core.v1.ReplicationControllerSpec]("spec")
          metadata <- obj.readOpt[io.k8s.apimachinery.pkg.apis.meta.v1.ObjectMeta]("metadata")
      } yield ReplicationController (
          status = status,
          spec = spec,
          metadata = metadata
        )
    }
}

